//
//  MCCIPUpdater.h
//  MCCloud
//
//  Created by Thomas Bartelmess on 11.02.10.
//  Copyright 2010 Marketcircle. All rights reserved.
//

#import <Cocoa/Cocoa.h>
#import "MCCIPUpdaterDelegate.h"


/*!
    @class		 MCCIPUpdater
    @abstract    An MCCIPUpdater object communicates with the MCCloud service to update the IPAddress of the Customer Server.
    @discussion  
*/

@interface MCCIPUpdater : NSObject {
	id <MCCIPUpdaterDelegate> delegate;
	NSString * cloudApplicationIdentifier;
}

/*!
    @function	updateIPForApplication:
    @abstract   Updates the IPAddress on MCCloud to the external IPAddress on MCCloud
    @discussion You can not pass a IPAddress MCCloud will update the IPAddress to the IPAddress the Request was made from.
    @param      cloudApplicationIdentifier application identifier identify the application on MCCloud. This should be the application identifier form, but can eventually be different.
*/

- (void)updateIPForApplication:(NSString *)aCloudApplicationIdentifier;

/*!
    @function	checkPort:
    @abstract   Checks if the given ports are available from extren
    @discussion The port checking is performed by the MCCloud. The results are passed to the delegate. MCCloud always checks the IP, the request to scan comes from.
    @param      port A port number that should be checked
*/


- (void)checkPort:(uint16)port;


@property (nonatomic, assign) id <MCCIPUpdaterDelegate> delegate;
@property (nonatomic, retain) NSString *applicationIdentifier;
@end
